<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('nature', 'account_number', 'tax_number', 'contact_person', 'description', 'user_id');
    protected $visible = array('nature', 'account_number', 'tax_number', 'contact_person', 'description', 'user_id');

    public function users()
    {
        return $this->hasOne('App\Models\User');
    }

    public function events()
    {
        return $this->hasMany('App\Models\Event');
    }

    public function invoices()
    {
        return $this->hasMany('App\Models\Invoice');
    }

}